<?php
/**
 * Domain Control page.
 *
 * @todo: Cleanup variable block at the top of the file.
 */

global $linkpatrol_domains, $linkpatrol_pagination;

// Add domain action must be at the top in order to provide table data consistency when updating
do_action( 'linkpatrol-adddomain' );
$domaindata = $linkpatrol_domains->get_domains_data();
$linkpatrol_row_number = $linkpatrol_pagination->getRowsNum();
$wlppage = $linkpatrol_pagination->getPagedNum();
$skey = $linkpatrol_pagination->getSkey();
$order = $linkpatrol_pagination->getOrder();
$orderby = $linkpatrol_pagination->getOrderBy();
$linkpatrol_pagination->addClasses( 'linkpatrol_pag' );
$linkpatrol_pagination->setCrumbs( 5 );
$linkpatrol_pagination->setRPP( $linkpatrol_row_number );
$linkpatrol_pagination->setRowsnum( $linkpatrol_row_number );
$linkpatrol_pagination->setCurrent( $wlppage );
if ( ! empty( $skey ) ) {
	$linkpatrol_pagination->setSkey( $skey );
}
$linkpatrol_pagination->setTotal( $domaindata[2] );
?>

<div class="wrap">
	<h2>Add or Remove Domain</h2>

	<form method="post"	action="<?php echo admin_url( 'admin.php?page=linkpatrol_domains_settings'); ?>">
		<div class="form-table linkpatrol_domains">
				<input type="hidden" name="_wpnonce_add_domain" value="<?php echo wp_create_nonce( 'linkpatrol_domain' )?>" size="80" />

				<p>
					<label for="linkpatrol_url">
						<?php _e( 'Add a domain to blacklist', 'linkpatrol' )?>
						<br />
						<input type="text" id="linkpatrol_url" class="regular-text" name="linkpatrol_url" value="" />
					</label>
				</p>

				<p>
					<label for="linkpatrol_nfoll">
						<input type="radio" name="linkpatrol_nfoll" id="linkpatrol_nfoll" value="0" checked="checked" />
						<span><?php _e( 'Nofollow', 'linkpatrol' ); ?></span>
					</label>

					<br />

					<label for="linkpatrol_strip">
						<input type="radio" name="linkpatrol_nfoll" id="linkpatrol_strip" value="1" />
						<span><?php _e( 'Strip', 'linkpatrol' ); ?></span>
					</label>
				</p>

				<p>
					<input type="submit" class="button-primary"	value="<?php _e( 'Add', 'linkpatrol' ) ?>" />
					<br />
					<br />
				</p>
		</div>
	</form>

	<hr />

	<?php $form_action = add_query_arg( array(), admin_url( 'admin.php?page=linkpatrol_domains_settings'  ) ); ?>
	<form id="edit-form-domain" method="post" action="<?php echo $form_action; ?>">	
		<input type="hidden" name="_wpnonce_updatedomain" value="<?php echo wp_create_nonce( 'linkpatrol_updatedomain' )?>" />
			
		<div class="linkpatrol_col1">	
			<p class="txt_left"><input type="text" name="skey" id="skey" value="<?php echo $skey;?>" placeholder="<?php _e('Search Domains', 'linkpatrol') ?>" /></p>
		</div>	

		<div class="linkpatrol_col2">
			<p class="txt_right">
				<label for="rowsnum"><?php _e('Rows', 'linkpatrol') ?>  <?php _e('No.', 'linkpatrol') ?></label>
				<input type="text" name="rowsnum" id="rowsnum" maxlength="3" size="3" value="<?php echo $linkpatrol_row_number;?>" />
				<input type="submit" class="button-primary"	value="<?php _e('Update', 'linkpatrol') ?>" />
			</p>
		</div>
	</form>

	<table class="wp-list-table widefat fixed posts domains-table">
		<thead>
			<tr>
				<th scope="col" class="manage-column sortable <?php echo $order;?>">
					<a href="<?php echo add_query_arg( array( 'orderby' => 'col1', 'order' => $order, 'wlppage' => $wlppage, 'rowsnum' => $linkpatrol_row_number, 'skey' => $skey ), admin_url( 'admin.php?page=linkpatrol_domains_settings' ) );?>">
						<span><?php _e('Domain', 'linkpatrol') ?></span>
						<span class="sorting-indicator"></span>
					</a>
				</th>
				<th scope="col" class="manage-column">
					<?php _e( 'Nofollow', 'linkpatrol' ); ?>
				</th>
				<th scope="col" class="manage-column">
					<?php _e( 'Strip', 'linkpatrol' ); ?>
				</th>
			</tr>
		</thead>

		<tfoot>
			<tr>
				<th scope="col" class="manage-column  sortable <?php echo $order;?>">
					<a href="<?php echo add_query_arg( array('orderby'=> 'col1', 'order'=> $order, "wlppage"=>$wlppage, 'rowsnum' => $linkpatrol_row_number), admin_url( 'admin.php?page=linkpatrol_domains_settings'  ) );?>">
					<span><?php _e('Domain', 'linkpatrol') ?></span>
					<span class="sorting-indicator"></span></a>
				</th>
				<th scope="col" class="manage-column"><?php _e( 'Nofollow', 'linkpatrol' ); ?></th>
				<th scope="col"  class="manage-column"> <?php _e( 'Strip', 'linkpatrol' ); ?></th>
			</tr>
		</tfoot>

		<tbody id="the-list">
			<?php 
			$i = 0;
			foreach ($domaindata[0] as $key=>$data) { ?>
			<tr <?php if ( $i%2 != 0 ) echo 'class="alternate"'; ?>>
				<td  class="domain ">
					<span class="dname"><input class="disabled domain_name"  disabled="true" type="text" value="<?php echo $data['col1']?>" name="domain[<?php echo $data['col3']?>]" ></span>
					
					<div class="row-actions">
						<span class="edit edit_domain"><a href="" title="Edit this item"><?php  _e( "Edit", 'linkpatrol' )?></a> |</span>
						<span class="trash">
							<a class="submitdelete" title="Delete this item" href="<?php echo  add_query_arg( array('delete_domain'=> $data['col3'], '_wpnonce_domain'=> wp_create_nonce( 'linkpatrol_domain' )), admin_url( 'admin.php?page=linkpatrol_domains_settings'  ) );  ?>" >
							<?php  _e( 'Delete', 'linkpatrol' )?></a>
						</span>
					</div>
				</td>
				
				<?php if ( $data['col2'] == 0 ) : // display strip/nofollow if blacklisted ?>
					<td>
						<input disabled="true" type="radio" name="linkpatrol_nfoll_edit[<?php echo $data['col3']?>]" id="linkpatrol_nfoll_edit" class="linkpatrol_nfoll_edit"	value="0"  checked="true" />
					</td>
					<td>
						<input disabled="true"  type="radio" name="linkpatrol_nfoll_edit[<?php echo $data['col3']?>]" id="linkpatrol_strip_edit" class="linkpatrol_nfoll_edit" value="1" />
					</td>
				<?php else: // blacklisted ?>
					<td>
						<input disabled="true" type="radio" name="linkpatrol_nfoll_edit[<?php echo $data['col3']?>]" id="linkpatrol_nfoll_edit" class="linkpatrol_nfoll_edit" value="0" />
					</td>
					<td>
						<input disabled="true" type="radio" name="linkpatrol_nfoll_edit[<?php echo $data['col3']?>]" id="linkpatrol_strip_edit" class="linkpatrol_nfoll_edit" value="1" checked="true" />
					</td>
				<?php endif;?>	 
			</tr>	
			<?php $i++; } // end foreach ?>  
		</tbody>
	</table>

	<div>
		<p>
			<input type="submit"  class="button-primary" value="<?php _e( 'Update', 'linkpatrol' ) ?>" />
		</p>
	</div>

	<?php
	// grab rendered/parsed pagination markup
	$markup = $linkpatrol_pagination->parse();
	echo $markup;
	?>

</div><!-- .wrap -->