<?php
// Scanner class
// this code includes debug codes 
class LinkPatrol_Scanner {
	private $prefix;
	private	$poststable;
	private $linkstable;
	private	$blog_domain;
	private	$taxonomytable;	
	private $hooksuff_scanner;
	private $hooksuff_main;
	private $hooksuffix_all;
	private $capability_reports;
	private $capability_mainopt;
	
	function LinkPatrol_Scanner() {
     	global $wpdb;
     	
		$this->prefix = $wpdb->prefix;
		$this->poststable = $this->prefix."posts";	
		$this->taxonomytable = $this->prefix . "term_relationships";
		$this->linkstable = $this->prefix . "linkpatrol_links";
		$this->blog_domain = parse_url ( get_option ( "siteurl" ), PHP_URL_HOST );
		
		add_action( 'admin_enqueue_scripts', array( &$this, 'linkpatrol_admin_vars' ) );
		
		add_action( 'admin_enqueue_scripts', array( &$this, 'linkpatrol_admin_enqueues' ) );
		add_action('admin_menu', array( &$this, 'linkpatrol_create_menu' ));
		add_action( 'admin_head-edit.php',                   array( &$this, 'add_bulk_actions_via_javascript' ) );
		add_action( 'admin_action_bulk_scan_posts_linkpatrol', array( &$this, 'bulk_action_handler' ) ); // Top drowndown
		add_action( 'admin_action_-1',                         array( &$this, 'bulk_action_handler' ) ); // Bottom dropdown (assumes top dropdown = default value)
		add_action( 'transition_post_status', array( &$this, 'post_statuschange_handler' ) , 10, 3 );
		add_action( 'wp_ajax_linkpatrolscanner',             array( &$this, 'ajax_process_posts' ) );
		add_action( 'admin_notices', array( &$this, 'bulk_scan_notice' ) );
		//add_action ( "linkpatrol-scan",  array( &$this, 'scan_all_posts_handler' ) );
		$this->capability_scanner = apply_filters( 'linkpatrol', 'edit_pages' );
		
	}
	
	

	
function add_bulk_actions_via_javascript() {
	if ( ! current_user_can( $this->capability_scanner ) )
		return;
	?>
<script type="text/javascript">
			jQuery(document).ready(function($){
				$('select[name^="action"] option:last-child').before('<option value="bulk_scan_posts_linkpatrol"><?php echo esc_attr( __( 'Scan Posts', 'linkpatrol' ) ); ?></option>');
			});
		</script>
<?php
	}
	

	function linkpatrol_admin_enqueues( $hook_suffix ) {
		wp_enqueue_style( 'linkpatrol-helper', LINKPATROL_PLUGIN_URL."css/helper.css", array());
		
		if(empty($this->hooksuffix_all))
			return;
		if (!in_array($hook_suffix, $this->hooksuffix_all))
			return;		
		
		wp_enqueue_script( 'jquery-ui' );
		wp_enqueue_script( 'jquery-ui-progressbar' );
		wp_enqueue_style( 'linkpatrol-jquery-ui-css',
			'http://ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/themes/redmond/jquery-ui.css',
			false,
			LINKPATROL_VER,
			false
		);	

		wp_enqueue_script( 'linkpatrol-scanner', LINKPATROL_PLUGIN_URL . 'js/linkpatrol-scanner.js', array( 'jquery' ), LINKPATROL_VER, true );
		wp_enqueue_style( 'linkpatrol-scan-style', LINKPATROL_PLUGIN_URL . 'css/style.css', array(), LINKPATROL_VER );
	}
	
	function linkpatrol_admin_vars($hook_suffix){
		if(empty($this->hooksuffix_all))
			return;
	if (!in_array($hook_suffix, $this->hooksuffix_all))
			return;
		
		?>
		<script type="text/javascript">
			var reports_pageurl = "<?php echo admin_url( 'admin.php?page=linkpatrol-overview'  ); ?>";
			var totalposts = <?php  echo $this->all_post_count(); ?>;
		</script>
		<?php 
	}
	
	function linkpatrol_create_menu() {
		//create new top-level menu
		$this->hooksuff_main =add_menu_page('Scanner Page', 'LinkPatrol', $this->capability_scanner, 'linkpatrol',  array( &$this, 'linkpatrol_scanner_page' ), 'dashicons-admin-links', '100000.5');
		$this->hooksuff_scanner = add_submenu_page( 'linkpatrol', 'Scanner', 'Scanner', $this->capability_scanner, 'linkpatrol_settings_scanner', array( &$this, 'linkpatrol_scanner_page' ));
		
		  //call register settings function
		$this->hooksuffix_all = array($this->hooksuff_main,$this->hooksuff_scanner  );		
	}
	
	
	function linkpatrol_scanner_page() {	
		require_once(LINKPATROL_PLUGIN_DIR."/optionspage/scanner-page.php");
	}
	
	function post_statuschange_handler( $new_status, $old_status, $post ) {
		if ( $old_status == 'publish' && $new_status != 'publish' ) {
			$this->remove_post_data(array($post->ID));			
		}
		else {
			$this->bulkscan_posts(array($post->ID));
		}
	}
	
	function bulk_action_handler() {
	
		if ( empty( $_REQUEST['action'] ) || ( 'bulk_scan_posts_linkpatrol' != $_REQUEST['action'] && 'bulk_scan_posts_linkpatrol' != $_REQUEST['action2'] ) )
			return;
		
		if ( ! current_user_can( $this->capability_scanner ) )
			wp_die( __( "You don't have enough permissions in order to make scan.", 'linkpatrol' ) );
			
		check_admin_referer( 'bulk-posts' );
	
		$count = count($_REQUEST['post']);
		if($count>0){
						
			$responce = $this->bulkscan_posts($_REQUEST['post'] );			
			wp_redirect( add_query_arg( array('scannedcount'=> $count, 'links_found'=> $responce[0], '_wpnonce_bulkscan'=> wp_create_nonce( 'bulk_scan_posts_linkpatrol' )), admin_url( 'edit.php'  ) ) );
		}		
		else{
			wp_redirect( add_query_arg( array('scannedcount'=> $count, '_wpnonce_bulkscan'=> wp_create_nonce( 'bulk_scan_posts_linkpatrol' )), admin_url( 'edit.php'  ) ) );
		}		
				
		exit();			
		
	}
	function edit_action_handler() {
	    $id = array($_POST["post_ID"]);	
		$this->bulkscan_posts($id);	
	}
	
	function restore_action_handler() {
		$id = array($_GET["post"]);
		$this->bulkscan_posts($id);
	
	}
	function delete_action_handler() {
		$id = array($_GET["post"]);		
		$this->remove_post_data($id);
	
	}
	
	function bulk_scan_notice() {
	
		if (isset ( $_GET ['_wpnonce_bulkscan'] )) {
			$nonce = $_GET ['_wpnonce_bulkscan'];
			if (! wp_verify_nonce ( $nonce, 'bulk_scan_posts_linkpatrol' )) {				
				wp_die( __( "You didn't pass security check", 'linkpatrol' ) );			
			} else {
				
				if (isset ( $_GET ['scannedcount'] )) {
					echo '<div class="updated">
			<p>' . sprintf ( __ ( 'Scanned posts: %1$s and %2$s Links were found', 'linkpatrol' ), $_GET ['scannedcount'], $_GET ['links_found'] ) . '</p>
			</div>';
				}
			}
		}
	}
	
	function prepare_url($url){
		if($url){
		if(stripos ( $url, "//" ) === 0) // it checks urls without protcols and adds it
		{
			$url = 'http:' . $url; // adding protocol
		}
		$url = trim(rtrim ( $url, '/' ));
		$url = preg_replace("/^https:/i", "http:", $url);
		$url = str_ireplace("http://www.", "http://", $url); //remove www
		
		return $url;
		}
		else return false;
	}

	function link_scanner($posts){
		$result_array = array();
		if($posts){
			foreach ( $posts as $value ) {		
				$postID = $value->ID;
				$post_content = trim($value->post_content);
				$postModDate=  $value->post_modified;
				if($post_content){
				$out = array();
				$dom = new DOMDocument;
			
		   		@$dom->loadHTML($post_content);
	
	       		$links = $dom->getElementsByTagName('a');
				foreach ($links as $link) {
	
				$url = trim($link->getAttribute('href'));
				$url = $this->prepare_url($url);	
				$out[] = array($url,$link->textContent, $dom->saveHTML($link));	
				
				}
		
				if ($out) {					
					foreach ( $out as $items ) {				
						
						$full_url = $items[0];
							
						$domain = parse_url ( $full_url, PHP_URL_HOST );  
						if(stripos ( $full_url, "mailto:" )=== false){ // don't index mailto anchor tags							
							// check for internal. If don't contain http at the begining, hostname is equal to blog hostname
							if ((stripos ( $full_url, "http://" ) !== 0 || $domain == $this->blog_domain) ){
							
								$domain = $this->blog_domain;						
							}							
							$helper = strtolower($full_url."".$postID); // unique ID					
							if (array_key_exists ( $helper, $result_array )) {
							
								$result_array [$helper] ["link_count"] ++;
								$result_array [$helper] ["anchor_text"] .= " | ".htmlentities($items [1]);
						
							} else {
						
								$result_array [$helper] = array (
										"anchor_tag" => htmlentities ( $items [2] ),
										"full_url" => $full_url,
										"domain" => $domain,
										"anchor_text" =>htmlentities($items [1]),
										"post_id" => $postID,
										"author_id" => $value->post_author,
										"post_date" => $postModDate,
										"link_count" => 1									
								);						
							}							
						} // end mailto if
					}// end foreach $out		
				} // end $out if		
			} // end of $post_content
		}
		}// end posts if
	
			return $result_array;
	}
		
		
		
	function scan_all_posts() {
	
		global $wpdb;
		
		$totalscanned = 0;
		$linksfound = 0; 
		$postsindexed = 0;
		$return_array = array("total_scanned"=>$totalscanned, "posts_indexed"=>$postsindexed);
		
		$posts = $wpdb->get_results ( $wpdb->prepare ( " SELECT  ID, post_author, post_content, post_modified, post_date FROM {$this->poststable} where post_status = 'publish' AND post_type IN ('post', 'page') ORDER BY post_date ASC" ) );
		$result_array = array ();
		
		if($posts){
			$result_array = $this->link_scanner($posts);
			$totalscanned = sizeof($posts);
	
	    if(!empty($result_array)){
		$querytobeinserted = "INSERT INTO {$this->linkstable}
		(anchor_tag, full_url, domain, anchor_text, post_id, author_id, post_date, link_count) VALUES ";
		$linksdata = array ();
		$place_holders = array ();
		foreach ( $result_array as $key => $value ) {
		if($value ["domain"]!=$this->blog_domain)			
		$linksfound = $linksfound+$value ["link_count"];
		array_push ( $linksdata, $value ["anchor_tag"], $value ["full_url"], $value ["domain"], $value ["anchor_text"], $value ["post_id"], $value ["author_id"],  $value ["post_date"], $value ["link_count"] );
		$place_holders [] = "('%s', '%s', '%s', '%s', '%d', '%d', '%s', '%d')";
	
		}
	
		$postsindexed = sizeof ( $place_holders );
		
		if (sizeof ( $place_holders ) > 0) {
		$querytobeinserted .= implode ( ', ', $place_holders );
		$wpdb->query ( $wpdb->prepare ( "TRUNCATE TABLE $this->linkstable " ) );
		$querytobeinserted = $wpdb->prepare ( $querytobeinserted, $linksdata );
		$wpdb->query ( $querytobeinserted );
	
		$return_array = array("total_scanned"=>$totalscanned, "links_found"=>$linksfound, "posts_indexed"=>$postsindexed);
		
		
	/*	update_option ( "linkpatrol_allscan_toalp", $totalscanned );
		if($totalscanned>0){		
		update_option ( "linkpatrol_allscan_toall", $linksfound );				
		}else 
		{		
			update_option ( "linkpatrol_allscan_toall", 0);
		
		}*/
	
		} 
		}// if empty $result_array
		}
		
		
		return $return_array;
	}
	

	function bulkscan_posts($ids) {
	
		global $wpdb;	
		$result_array = array ();
	
		$sqlFinal = "";
		$sqlStart = "SELECT  ID, post_author, post_content, post_modified, post_date FROM {$this->poststable} where post_status IN ('publish') AND post_type IN ('post','page') ";
		$sqlEnd = " ORDER BY post_date ASC";
	
		$placeholders = array();
		foreach ($ids as $value) {
			$placeholders[] = "%s";
		}
					
		if (  ! empty( $ids )){
			$inPart = "AND ID IN (" . implode ( ",", $placeholders ) . ")";
		
	
		$sqlFinal = $sqlStart . $inPart . $sqlEnd;
	   
		$posts = $wpdb->get_results ( $wpdb->prepare ( $sqlFinal, $ids) );
		
		$result_array = array ();
		$result_array = $this->link_scanner($posts);
	
		foreach ( $result_array as $key => $value ) {
			$rowsnum = $wpdb->delete ( $this->linkstable, array (
					'post_id' => $value ["post_id"]
			), array (
					'%d'
			) );
		}
         
		
		$link_count = 0;
		foreach ( $result_array as $key => $value ) {
			$link_count = $link_count+ $value["link_count"];
			$rowsnum = $wpdb->insert ( $this->linkstable, array (
					"anchor_tag" => $value["anchor_tag"],
					"full_url" => $value["full_url"],
					"domain" => $value["domain"],
					"anchor_text" =>$value["anchor_text"],
					"post_id" => $value["post_id"],
					"author_id" => $value["author_id"],					
					"post_date" => $value["post_date"],
					"link_count" => $value["link_count"],
	
			), array (
					'%s',
					'%s',
					'%s',
					'%s',
					'%d',
					'%d',
					'%s',
					'%d'
			) );
	
		}
	
	}
	
	return array($link_count);
	}
	
	function remove_post_data($ids) {
		global $wpdb;		
		foreach ( $ids as  $value ) {
			$rowsnum = $wpdb->delete ( $this->linkstable, array (
					'post_id' => $value
			), array (
					'%d'
			) );
		}
	}
	
	function ajax_process_posts(){
		global $wpdb; 
		$offset = (int) $_REQUEST['offset'];
		$rowsperpage = (int) $_REQUEST['limit'];
		
		@error_reporting( 0 ); // Don't break the JSON result
		
		header( 'Content-type: application/json' );
			
			if($offset==0){
				$wpdb->query ( "TRUNCATE TABLE $this->linkstable" );
			
			}
	
		$totalscanned = 0;
		$linksfound = 0;
		$postsindexed = 0;
		$return_array = array("total_scanned"=>$totalscanned, "posts_indexed"=>$postsindexed);
		
		$posts = $wpdb->get_results ( $wpdb->prepare ( 
		"SELECT  ID, post_author, post_content, post_modified, post_date 
		FROM {$this->poststable} where post_status = 'publish' 
		AND post_type IN ('post', 'page') 
		ORDER BY post_date DESC LIMIT  %d, %d", $offset, $rowsperpage) );
	//	$xxx =  $wpdb->prepare ( " SELECT  ID, post_author, post_content, post_modified, post_date FROM {$this->poststable} where post_status = 'publish' AND post_type IN ('post', 'page') ORDER BY post_date DESC LIMIT  {$offset}, {$rowsperpage}" ) ;
	
		if($posts){
			$result_array = $this->link_scanner($posts);
			if($result_array){
			$totalscanned = sizeof($posts);
	
			$querytobeinserted = "INSERT INTO {$this->linkstable}
			(anchor_tag, full_url, domain, anchor_text, post_id, author_id, post_date, link_count) VALUES ";
			$linksdata = array ();
			$place_holders = array ();
			foreach ( $result_array as $key => $value ) {
			//	echo $key . "=>" . $value ["full_url"] . " post_id: " . $value ["post_name"] . " count: " . $value ["count"] . "<br/>";
				if($value ["domain"]!=$this->blog_domain)
				$linksfound = $linksfound+$value ["link_count"];
				array_push ( $linksdata, $value ["anchor_tag"], $value ["full_url"], $value ["domain"], $value ["anchor_text"], $value ["post_id"], $value ["author_id"],  $value ["post_date"], $value ["link_count"] );
				$place_holders [] = "('%s', '%s', '%s', '%s', '%d', '%d', '%s', '%d')";
		
			}
		
			$postsindexed = sizeof ( $place_holders );
		
			if (sizeof ( $place_holders ) > 0) {
			$querytobeinserted .= implode ( ', ', $place_holders );		
			$querytobeinserted = $wpdb->prepare ( $querytobeinserted, $linksdata );
			$wpdb->query ( $querytobeinserted );		
			$return_array = array("total_scanned"=>$totalscanned, "links_found"=>$linksfound, "posts_indexed"=>$postsindexed);
		
		
		
			}
			}
		}
		
		die( json_encode( array( 'success' => sprintf( __( '%1$s Posts was successfully indexed. Links found %2$s. Offset %3$s  Rows %4$s', 'regenerate-thumbnails' ), $totalscanned, $linksfound, $offset, $rowsperpage ) ) ) );
								
	}
	
	
	function all_post_count() {
		global $wpdb;
		$sql = "SELECT count(ID)  FROM {$this->poststable}  where post_status = 'publish' AND post_type IN ('post', 'page')";
		$results = $wpdb->get_col($sql);
		
		return $results[0];
		
		
	}
	
}