<?php
require_once(LINKPATROL_PLUGIN_DIR."/libs/paginator/class-pagination.php");

class LinkPatrol_Reports {
	private $prefix;
	private $base_prefix;
	private	$poststable;
	private	$userstable;
	private $linkstable;
	private $domainstable;
	//private $urlstable;
	private	$blog_domain;
	private	$hooksuffix_all;
	private	$hooksuff_reports;
	private	$hooksuff_main;
	private $capability_mainopt;
	private $hooksuff_reports_dom;
	private $paginationObj;
	private $domainsObj;
	private $user_id;
	
	function LinkPatrol_Reports() {
		global $wpdb;
				
		$this->prefix = $wpdb->prefix;
		$this->base_prefix = $wpdb->base_prefix;		
		$this->poststable = $this->prefix."posts";
		$this->taxonomytable = $this->prefix . "term_relationships";
		$this->userstable  = $this->base_prefix . "users";
		$this->linkstable = $this->prefix . "linkpatrol_links";
		$this->domainstable = $this->prefix . "linkpatrol_bwlisted";
		$this->user_id = get_current_user_id();
		//$this->urlstable = $this->prefix . "linkpatrol_bwurls";
		$this->blog_domain = parse_url ( get_option ( "siteurl" ), PHP_URL_HOST );
		$this->blog_domain_escaped = '%' .like_escape( $this->blog_domain ). '%';
		$this->paginationObj = new LinkPatrol_Pagination();
	
		add_action( 'wp_ajax_linkpatroloverview', array( &$this, 'ajax_overviewdata' ) );
		add_action( 'wp_ajax_linkpatrolurlupdate', array( &$this, 'ajax_url_control' ) );
		add_action( 'init', array( &$this, 'ajax_csv_export_handler' ), 1000 );
	
		add_action( 'admin_enqueue_scripts', array( &$this, 'linkpatrol_reports_enqueues' ) );
		add_action('admin_menu', array( &$this, 'linkpatrol_reports_menu' ));
		$this->capability_mainopt = apply_filters( 'linkpatrol', 'edit_pages' );
		$this->capability_reports = apply_filters( 'linkpatrol', 'edit_pages' );
		
		
	}
	
	function linkpatrol_reports_enqueues( $hook_suffix ) {
		if(empty($this->hooksuffix_all))
			return;
		if (!in_array($hook_suffix, $this->hooksuffix_all))
			return;			
		
		wp_register_script( 'jqplot', LINKPATROL_PLUGIN_URL."js/charts/jquery.jqplot.js",array('jquery') );
		wp_enqueue_script('jqplot');
		wp_enqueue_script( 'linkpatrol-pieRenderer', LINKPATROL_PLUGIN_URL."js/charts/jqplot.pieRenderer.min.js", array('jqplot'));
		wp_enqueue_script( 'linkpatrol-barRenderer', LINKPATROL_PLUGIN_URL."js/charts/jqplot.barRenderer.min.js", array('jqplot'));
		wp_enqueue_script( 'linkpatrol-categoryAxisRenderer', LINKPATROL_PLUGIN_URL."js/charts/jqplot.categoryAxisRenderer.min.js", array('jqplot'));
		wp_enqueue_script( 'linkpatrol-pointLabels', LINKPATROL_PLUGIN_URL."js/charts/jqplot.pointLabels.min.js", array('jqplot'));
		wp_enqueue_script( 'linkpatrol-charts', LINKPATROL_PLUGIN_URL."js/linkpatrol-charts.js", array('jqplot'), LINKPATROL_VER);
		wp_enqueue_script( 'linkpatrol-reports', LINKPATROL_PLUGIN_URL."js/linkpatrol-reports.js", array('jqplot'), LINKPATROL_VER);
		wp_enqueue_style( 'linkpatrol-jqplot', LINKPATROL_PLUGIN_URL."js/charts/jquery.jqplot.css");		
		wp_enqueue_style( 'linkpatrol-scan-style', LINKPATROL_PLUGIN_URL."css/style.css", array(), LINKPATROL_VER);
		$params = array(				
				'reports_ajax_nonce' => wp_create_nonce('reports_ajax'),
		);
		wp_localize_script( 'linkpatrol-reports', 'ajax_object', $params );
	}
	
	
	
	function linkpatrol_reports_menu() {
		// create new top-level menu
		$this->hooksuff_report = add_submenu_page( 'linkpatrol', 'LinkPatrol Reports', 'Reports', $this->capability_reports, 'linkpatrol-overview', array( &$this, 'linkpatrol_reports_page' ));
		
		// call register settings function
		$this->hooksuffix_all = array($this->hooksuff_report);		
	}
		
	function linkpatrol_reports_page() {
		if(!empty($_GET['_wpnonce_domainreport_page']))
		require_once(LINKPATROL_PLUGIN_DIR."/optionspage/reports/domain-reports-page.php");
		else
		if(!empty($_GET['_wpnonce_authorreport_page']))
			require_once(LINKPATROL_PLUGIN_DIR."/optionspage/reports/authors-reports-page.php");	
		else
		if(!empty($_GET['_wpnonce_domainpostreport_page']))
			require_once(LINKPATROL_PLUGIN_DIR."/optionspage/reports/domain-posts-reports-page.php");
		else if(!empty($_GET['_wpnonce_authordomainreport_page']))
			require_once(LINKPATROL_PLUGIN_DIR."/optionspage/reports/authors-domain-reports-page.php");	
		else if(!empty($_GET['_wpnonce_keywordsreport_page']))		
			require_once(LINKPATROL_PLUGIN_DIR."/optionspage/reports/keywords-report-page.php");
		else if(!empty($_GET['_wpnonce_authordomainpostreport_page']))
			require_once(LINKPATROL_PLUGIN_DIR."/optionspage/reports/author-domain-link-reports.php");
		else if(!empty($_GET['_wpnonce_allauthorreport_page']))
			require_once(LINKPATROL_PLUGIN_DIR."/optionspage/reports/all-authors-domain-reports.php");
		else if(!empty($_GET['_wpnonce_domainauthorpostreport_page']))
			require_once(LINKPATROL_PLUGIN_DIR."/optionspage/reports/domain-author-posts-reports-page.php");
		else 
			require_once(LINKPATROL_PLUGIN_DIR."/optionspage/reports-page.php");
		
		
		
	}
	function linkpatrol_domain_reports_page() {
	
		require_once(LINKPATROL_PLUGIN_DIR."/optionspage/domain-reports-page.php");
	}
	
	function process_request_vars(){
		
	}
	
	function get_distinct_col_link($domain){
		global $wpdb;
		$column = $wpdb->get_col( "SELECT DISTINCT domain FROM {$this->linkstable}");		
		if($column)
			return $column;
		else
			false;		
	}
	
	function domain_total_links(){
		
		global $wpdb;
		$responce = array("result"=>array(), "chk"=>false); // chk check if query was successful
		$sql = "SELECT domain as col1, SUM(link_count) as col2 
		FROM {$this->linkstable} where domain not LIKE %s 
		GROUP BY col1 ORDER BY col2 DESC LIMIT 10";
		$result = $wpdb->get_results($wpdb->prepare($sql, $this->blog_domain_escaped), ARRAY_A);
		if($result!==false){
		$responce["chk"] = true;
		for ($i = (count($result)-1); $i >=0; $i--) {
			$responce["result"][$result[$i]["col1"]] = $result[$i]["col2"];
		}
		
		/*foreach ($result as $value) {
		$responce["result"][$value["col1"]] = $value["col2"];
		}*/
		}
		
		return $responce;		
		
	}
	
	function authors_avg_links(){
		global $wpdb;
		$responce = array("result"=>array(), "chk"=>false);
		$sql = "SELECT author_id as col1, SUM(link_count)/COUNT(DISTINCT post_id) as col2, author_id as col3 
		FROM {$this->linkstable} where domain not LIKE %s GROUP BY col1 ORDER BY col2 DESC LIMIT 10";
		
		$result = $wpdb->get_results($wpdb->prepare($sql,$this->blog_domain_escaped), ARRAY_A);
		if($result!==false)	{
		$responce["chk"] = true;
		for ($i = (count($result)-1); $i >=0; $i--) {
			$user_info = get_userdata($result[$i]["col1"]);
			//$responce[$key]["col1"] = $user_info->display_name;
			$responce["result"][$user_info->display_name] = number_format($result[$i]["col2"],1);
		}
		
		/*foreach ($result as $key => $value) {			
		$user_info = get_userdata($value["col1"]);
		//$responce[$key]["col1"] = $user_info->display_name;		
		$responce["result"][$user_info->display_name] = $value["col2"];
		}*/
		}		
		//print_r($responce);
		return $responce;		
	}
	
	function links_overview(){
		
		$totalp = $this->get_all_published_posts();
		$totall = $this->get_links_total_data();			
		if($totall["posts_count"]!=0){
			$avg = $totall["links_count"]/$totall["posts_count"];
		}else{
			$avg = 0;
		}
		return array($totalp["posts_count"], $totall["links_count"], $avg);
		
	}
	
	function get_days_interval(){
		$days_interval = get_user_meta( $this->user_id, 'linkpatrol_dateint', true );
		if($days_interval)
			return $days_interval;
		else
			return 99999999;
	}
	function get_rows_number(){
		$rows_number = get_user_meta( $this->user_id, 'linkpatrol_rowsnum', true );
		if($rows_number)
			return $rows_number;
		else
			return 50;
	}
	
	function get_domains_report_data(){
		 
		global $wpdb;
		$keyword = $this->paginationObj->getSkey();
		$keyword = '%' .like_escape( $keyword ). '%';	
		$days_interval = $this->get_days_interval();
		$rowsperpage = $this->get_rows_number();
		
		$sql_total = "SELECT DISTINCT domain  FROM {$this->linkstable} 
		WHERE domain LIKE %s and domain NOT LIKE %s AND DATEDIFF(CURDATE(), post_date) <= %d";
		$totaldata = $wpdb->get_results($wpdb->prepare($sql_total, $keyword, $this->blog_domain_escaped, $days_interval),ARRAY_A);		
	 
		if(!empty($totaldata)){
			$pagenum = count($totaldata);			
		}
		else {
			$pagenum = 0;
		}		
				
		
		$currentpage = $this->paginationObj->getPagedNum();			
		$order =  $this->paginationObj->getOrder();
		$this->paginationObj->setOrderBy("col2");
		$orderby =  $this->paginationObj->getOrderBy();
	
		$offset = ($currentpage - 1) * $rowsperpage;
	
		
		
	/*	echo "<br/>rep<br/>";
		echo var_dump($days_interval);
		echo "<br/>rep<br/>";*/
		
		$sql_tplt = "SELECT domain as col1,  SUM(link_count) as col2, COUNT(post_id) as col3, COUNT(DISTINCT author_id) as col6 
		FROM {$this->linkstable} 
		WHERE domain LIKE %s AND domain NOT LIKE %s 
		AND DATEDIFF(CURDATE(), post_date) <= %d
		GROUP BY col1 ORDER BY {$orderby} {$order} LIMIT %d, %d";
		$tplt = $wpdb->get_results($wpdb->prepare($sql_tplt, $keyword, $this->blog_domain_escaped, $days_interval, $offset, $rowsperpage), ARRAY_A);
		//echo $wpdb->prepare($sql_tplt, $keyword, $this->blog_domain_escaped, $days_interval, $offset, $rowsperpage);
				
		foreach ($tplt as $key => $value) {
			$chk = $this->get_domain_data($value["col1"]);
			//print_r($chk);
			$tplt[$key]["col5"]  = $chk[2];
			if($chk[0] && $chk[1]){
				$tplt[$key]["col4"]  = 1;			
			}
			else if($chk[0] && !$chk[1]){
				$tplt[$key]["col4"] = 0;
			
			}
			else{
				$tplt[$key]["col4"] = -1;				
			}
		}
			
		return array($tplt,$pagenum);		
	}
	
	function get_domain_post_report_data($domain){
		global $wpdb;
		$keyword = $this->paginationObj->getSkey();
		$keyword = '%' .like_escape( $keyword ). '%';
		$days_interval = $this->get_days_interval();
		$rowsperpage = $this->get_rows_number();
		
		$sql_total = "SELECT distinct post_id  FROM {$this->linkstable} WHERE domain = %s AND anchor_text LIKE %s AND DATEDIFF(CURDATE(), post_date) <= %d";
		$totaldata = $wpdb->get_results($wpdb->prepare($sql_total, $domain, $keyword, $days_interval),ARRAY_A);
	
		if(!empty($totaldata)){
			$pagenum = count($totaldata);
		}
		else {
			$pagenum = 0;
		}
	
	  	$currentpage = $this->paginationObj->getPagedNum();		
		$order =  $this->paginationObj->getOrder();
		$orderby =  $this->paginationObj->getOrderBy();
	
		$offset = ($currentpage - 1) * $rowsperpage;
	
		$sql_tplt = "SELECT post_id as col1, anchor_text as col2, full_url as col3, DATE_FORMAT(post_date,'%%m/%%d/%%Y') as col4, author_id as col5, fol_strip as col6, ID as col7 
		FROM {$this->linkstable} WHERE domain = %s AND anchor_text LIKE %s AND DATEDIFF(CURDATE(), post_date) <= %d
		ORDER BY {$orderby} {$order} LIMIT %d, %d";
		$tplt = $wpdb->get_results($wpdb->prepare($sql_tplt, $domain, $keyword, $days_interval, $offset, $rowsperpage), ARRAY_A);
			 
		return array($tplt,$pagenum);	
	}
	
	// working on this
	function get_domain_author_post_report_data($domain, $authorid){
		global $wpdb;
		$keyword = $this->paginationObj->getSkey();
		$keyword = '%' .like_escape( $keyword ). '%';
		$days_interval = $this->get_days_interval();
		$rowsperpage = $this->get_rows_number();
	
		$sql_total = "SELECT distinct post_id  FROM {$this->linkstable} 
		WHERE domain = %s AND anchor_text LIKE %s and author_id=%d AND DATEDIFF(CURDATE(), post_date) <= %d";
		$totaldata = $wpdb->get_results($wpdb->prepare($sql_total, $domain, $keyword, $authorid, $days_interval),ARRAY_A);

		if(!empty($totaldata)){
			$pagenum = count($totaldata);
		}
		else {
			$pagenum = 0;
		}
		
		$currentpage = $this->paginationObj->getPagedNum();	
		$order =  $this->paginationObj->getOrder();
		$orderby =  $this->paginationObj->getOrderBy();	
		$offset = ($currentpage - 1) * $rowsperpage;
	
		$sql_tplt = "SELECT post_id as col1, anchor_text as col2, full_url as col3, DATE_FORMAT(post_date,'%%m/%%d/%%Y') as col4, author_id as col5, fol_strip as col6, ID as col7
		FROM {$this->linkstable} 
		WHERE domain = %s AND author_id = %d AND anchor_text LIKE %s 
		AND DATEDIFF(CURDATE(), post_date) <= %d
		ORDER BY {$orderby} {$order} LIMIT %d, %d";
		
		$tplt = $wpdb->get_results($wpdb->prepare($sql_tplt, $domain, $authorid, $keyword, $days_interval, $offset, $rowsperpage), ARRAY_A);
	
		return array($tplt,$pagenum);
	
	}
	
	
	function get_author_domain_report_data( $authid ) {  
		global $wpdb;
		$keyword = $this->paginationObj->getSkey();
		$keyword = '%' .like_escape( $keyword ). '%';
		$days_interval = $this->get_days_interval();
		$rowsperpage = $this->get_rows_number();
	
		$sql_total = "SELECT domain FROM {$this->linkstable} 
		WHERE author_id = %d AND domain LIKE %s AND domain NOT LIKE %s AND DATEDIFF(CURDATE(), post_date) <= %d  
		GROUP BY domain";
		$totaldata = $wpdb->get_results($wpdb->prepare($sql_total, $authid, $keyword, $this->blog_domain_escaped, $days_interval),ARRAY_A);
		
		if(!empty($totaldata)){
			$pagenum = count($totaldata);
		}
		else {
			$pagenum = 0;
		}
	
		$currentpage = $this->paginationObj->getPagedNum();	
		$this->paginationObj->setOrderBy("col2");
		$order =  $this->paginationObj->getOrder();
		$orderby =  $this->paginationObj->getOrderBy();	
		$offset = ($currentpage - 1) * $rowsperpage;
	
		$sql_tplt = 		
		"SELECT domain as col1, SUM(link_count) as col2 
		FROM {$this->linkstable} 
		WHERE author_id = %d AND domain LIKE %s AND domain not LIKE %s AND DATEDIFF(CURDATE(), post_date) <= %d	
		GROUP BY col1
		ORDER BY {$orderby} {$order} LIMIT %d, %d";
		$tplt = $wpdb->get_results($wpdb->prepare($sql_tplt, $authid, $keyword, $this->blog_domain_escaped, $days_interval, $offset, $rowsperpage), ARRAY_A);
		
		foreach ($tplt as $key => $value) {
			$chk = $this->get_domain_data($value["col1"]);
			
		
			if($chk[0] && $chk[1]){
				$tplt[$key]["col3"]  = 1;
			
			}
			else if($chk[0] && !$chk[1]){
				$tplt[$key]["col3"] = 0;
			
			}
			else{
				$tplt[$key]["col3"] = -1;
				
			}
		}
		
		
		return array($tplt,$pagenum);
	
	}
	
	function get_author_domain_post_report_data($domain,$authid){
		global $wpdb;
		$keyword = $this->paginationObj->getSkey();
		$keyword = '%' .like_escape( $keyword ). '%';
		$days_interval = $this->get_days_interval();
		$rowsperpage = $this->get_rows_number();
		
		$sql_total = "SELECT DISTINCT post_id, anchor_text  FROM {$this->linkstable} 
		WHERE domain=%s AND anchor_text LIKE %s AND author_id=%d AND DATEDIFF(CURDATE(), post_date) <= %d ORDER BY post_id DESC";
		$totaldata = $wpdb->get_results($wpdb->prepare($sql_total, $domain, $keyword, $authid, $days_interval),ARRAY_A);
		
		if(!empty($totaldata)){
			$pagenum = count($totaldata);
		}
		else {
			$pagenum = 0;
		}
				
		$currentpage = $this->paginationObj->getPagedNum();	
		$order =  $this->paginationObj->getOrder();
		$orderby =  $this->paginationObj->getOrderBy();	
		$offset = ($currentpage - 1) * $rowsperpage;
	
		$sql_tplt = "SELECT DISTINCT post_id AS col1, 
		anchor_text AS col2, full_url AS col3, DATE_FORMAT(post_date,'%%m/%%d/%%Y') AS col4, fol_strip AS col5, ID AS col6		
		FROM {$this->linkstable} WHERE domain = %s AND anchor_text LIKE %s AND author_id=%d AND DATEDIFF(CURDATE(), post_date) <= %d
		ORDER BY {$orderby} {$order} LIMIT %d, %d";
		$tplt = $wpdb->get_results($wpdb->prepare($sql_tplt, $domain, $keyword, $authid, $days_interval, $offset, $rowsperpage  ), ARRAY_A);
		
		return array($tplt,$pagenum);	
	}
	
// Working on this---------------------

	function get_all_authors_domain_report_data($domain){
		global $wpdb;
		$keyword = $this->paginationObj->getSkey();
		$keyword = '%' .like_escape( $keyword ). '%';
		$days_interval = $this->get_days_interval();
		$rowsperpage = $this->get_rows_number();
		
		$sql_total = "
		SELECT links.author_id AS col4,	
		users.display_name AS col1
		FROM {$this->linkstable} AS links INNER JOIN {$this->userstable} AS users
		ON links.author_id = users.ID 
		WHERE users.display_name LIKE %s AND links.domain=%s AND DATEDIFF(CURDATE(), links.post_date) <= %d
		GROUP BY links.author_id";
		$totaldata = $wpdb->get_results($wpdb->prepare($sql_total, $keyword, $domain, $days_interval),ARRAY_A);
	
		if(!empty($totaldata)){
			$pagenum = count($totaldata);
		}
		else {
			$pagenum = 0;
		}
		
		$currentpage = $this->paginationObj->getPagedNum();	
		$order =  $this->paginationObj->getOrder();
		$this->paginationObj->setOrderBy("col3");
		$orderby =  $this->paginationObj->getOrderBy();
	
		$offset = ($currentpage - 1) * $rowsperpage;
	
		$sql_tplt = "
		SELECT links.author_id AS col4 ,  		
		COUNT(DISTINCT links.post_id) AS col2, 	
		SUM(links.link_count) AS col3,		
		users.display_name AS col1 
		FROM {$this->linkstable} AS links INNER JOIN {$this->userstable} AS users 
		ON links.author_id = users.ID 
		WHERE users.display_name LIKE %s AND links.domain=%s AND DATEDIFF(CURDATE(), links.post_date) <= %d
		GROUP BY col4 ORDER BY {$orderby} {$order} LIMIT %d, %d
		";
		$resultarray = $wpdb->get_results($wpdb->prepare($sql_tplt, $keyword, $domain, $days_interval, $offset, $rowsperpage), ARRAY_A);
		
		return array($resultarray,$pagenum);
	}
	
	function get_authorsreport_data(){
		global $wpdb;
		$keyword = $this->paginationObj->getSkey();
		$keyword = '%' .like_escape( $keyword ). '%';
		$days_interval = $this->get_days_interval();
		$rowsperpage = $this->get_rows_number();

		$sql_total = "
		SELECT links.author_id AS col4,	
		users.display_name AS col1
		FROM {$this->linkstable} AS links INNER JOIN {$this->userstable} AS users
		ON links.author_id = users.ID 
		WHERE users.display_name LIKE %s AND links.domain not LIKE %s AND DATEDIFF(CURDATE(), links.post_date) <= %d
		GROUP BY links.author_id";
		$totaldata = $wpdb->get_results($wpdb->prepare($sql_total, $keyword, $this->blog_domain_escaped, $days_interval),ARRAY_A);
	
		if(!empty($totaldata)){
			$pagenum = count($totaldata);
		}
		else {
			$pagenum = 0;
		}
	
	
		
		$currentpage = $this->paginationObj->getPagedNum();	
		$order =  $this->paginationObj->getOrder();
		$this->paginationObj->setOrderBy("col3");
		$orderby =  $this->paginationObj->getOrderBy();
	
		$offset = ($currentpage - 1) * $rowsperpage;
	
		$sql_tplt = "
		SELECT links.author_id AS col4 ,  
		SUM(links.link_count)/COUNT(DISTINCT links.post_id) AS col3, 
		COUNT(DISTINCT links.post_id) AS col2, 		 
		users.display_name AS col1 
		FROM {$this->linkstable} AS links INNER JOIN {$this->userstable} AS users 
		ON links.author_id = users.ID 
		WHERE users.display_name LIKE %s AND links.domain not LIKE %s AND DATEDIFF(CURDATE(), links.post_date) <= %d
		GROUP BY col4 ORDER BY {$orderby} {$order} LIMIT %d, %d";
		
		$resultarray = $wpdb->get_results($wpdb->prepare($sql_tplt, $keyword, $this->blog_domain_escaped, $days_interval, $offset, $rowsperpage ), ARRAY_A);		
		return array($resultarray,$pagenum);	
	}
	
	
	function get_keyword_report_data($skey){
		global $wpdb;
		
		$keyword = '%' .like_escape( $skey ). '%';
		$days_interval = $this->get_days_interval();
		$rowsperpage = $this->get_rows_number();
	
		$sql_total = "SELECT ID FROM {$this->linkstable} WHERE anchor_text LIKE %s AND domain not LIKE %s AND DATEDIFF(CURDATE(), post_date) <= %d";
		$totaldata = $wpdb->get_results($wpdb->prepare($sql_total, $keyword, $this->blog_domain_escaped, $days_interval),ARRAY_A);
		
		if(!empty($totaldata)){
			$pagenum = count($totaldata);
		}
		else {
			$pagenum = 0;
		}
		
		
		$currentpage = $this->paginationObj->getPagedNum();
		$order =  $this->paginationObj->getOrder();
		$orderby =  $this->paginationObj->getOrderBy();
		$offset = ($currentpage - 1) * $rowsperpage;	
		$sql_tplt = "SELECT post_id AS col1, anchor_text AS col2, full_url AS col3, 
		DATE_FORMAT(post_date,'%%m/%%d/%%Y') AS col4, author_id AS col5, fol_strip AS col6, ID AS col7
		FROM {$this->linkstable} WHERE anchor_text LIKE %s AND domain NOT LIKE %s AND DATEDIFF(CURDATE(), post_date) <= %d
		ORDER BY {$orderby} {$order} LIMIT %d, %d";
		$tplt = $wpdb->get_results($wpdb->prepare($sql_tplt, $keyword, $this->blog_domain_escaped, $days_interval, $offset, $rowsperpage), ARRAY_A);
	/*	foreach ($tplt as $key=>$value) {
			$tplt[$key]["col2"] = $value["col21"]."<br/>".'<a target="_blank" href="'.$value["col22"].'">'.$value["col22"]."</a>";
		}*/
		
		return array($tplt,$pagenum);	
	}
	
	
	
	
	
	function get_domain_data($domain_chk){
		global $wpdb;
		$responce = array(0, false, 0);
	
		$keyword = '%' .like_escape( $domain_chk ). '%';
		
		if($domain_chk){
			$sql = "SELECT ID, domain,  fol_strip FROM {$this->domainstable} WHERE domain LIKE %s LIMIT 1";
			$results = $wpdb->get_results($wpdb->prepare($sql, $keyword), ARRAY_A);
			
			if($results){
					
				$responce = array(1, $results[0]["fol_strip"], $results[0]["ID"]);
	
			}			
		}
		
		return $responce;
	
	}
	
	function check_links_table(){
		global $wpdb;
		$sql = "SELECT ID  FROM {$this->linkstable}";
		$results = $wpdb->get_col($sql);
		
		if(count($results)>0){				
			return true;		
		}
		else {
			return false;
		}
		
	}
	
	
	function get_links_total_data(){
		global $wpdb;
		$responce = array("links_count"=>0, "internal_count"=>0, "external_count"=>0, "posts_count"=>0, "chk"=>false);
		$sql_total = "SELECT SUM(link_count),  COUNT(DISTINCT post_id) FROM {$this->linkstable}";
		// get 
		$totaldataQ = $wpdb->get_results($sql_total,ARRAY_N);
	
 		if($totaldataQ!==false){
		 $responce = array("links_count"=>$totaldataQ[0][0],  "posts_count"=>$totaldataQ[0][1], "chk"=>true);
		
		}
		
		$internal = $this->get_internal();
	
		if($internal["chk"]!==false){
			$responce["internal_count"] = $internal['count'];
			$responce["external_count"] = ($totaldataQ[0][0]-$internal["count"]);
		}
		else {
			$responce["chk"] = false;
		}
		
		
		return $responce;		
	}
	
	function get_internal(){
		global $wpdb;
		$internal_count = array("count"=>0,"chk"=>false);
		$sql_internal = "SELECT SUM(link_count) FROM {$this->linkstable} 
		WHERE domain = %s ";
		$internalQ = $wpdb->get_col( $wpdb->prepare($sql_internal, $this->blog_domain ) );
		if($internalQ!==false){
			$internal_count = array("count"=>$internalQ[0],"chk"=>true);
		}
		
		return $internal_count;
	}
	
	function get_all_published_posts(){
		global $wpdb;
		
		$responce = array("count"=>0,"chk"=>false );
		$allpostQ =  "SELECT COUNT(ID) as col1 FROM {$this->poststable} 
		WHERE post_status = 'publish' AND post_type IN ('post', 'page')";
		$allpost  = $wpdb->get_col( $allpostQ );
	
		if($allpost!==false){			
			$responce = array("posts_count"=>$allpost[0],"chk"=>true );
		}
		return $responce;
	}
	
	function ajax_overviewdata(){
		global $wpdb;			
		
		$totals =  $this->get_links_total_data();		  
		$allposts  = $this->get_all_published_posts();
		$domains = $this->domain_total_links();
		$authavg = $this->authors_avg_links();
		//print_r($authavg);
		// plot2 links per post
		$perpostresp = array("zero"=>0, "zero_four" => array(), "fiveplus"=>0, "chk"=>false );
		
		if($totals["chk"]!==false && $allposts["chk"]!==false){
		$perpostresp["zero"]=($allposts["posts_count"]-$totals["posts_count"]); // posts with no links
		$perpostresp["chk"] = true;
		}
		
		$sql_perpostllinks = 
		"SELECT COUNT(col11) AS col1, col22 AS col2 
		FROM  (SELECT post_id AS col11, SUM(link_count) AS col22 
		FROM {$this->linkstable} 
		GROUP BY col11 ORDER BY col11 DESC) AS table1 
		GROUP BY col2 ORDER BY col2 ASC LIMIT 4;";
		$perpostllinks  = $wpdb->get_results( $sql_perpostllinks, ARRAY_A );
	   // print_r($perpostllinks);
		$firstfive = 0; // total of first five
		if($perpostllinks!==false){
			
			foreach ($perpostllinks as $value) {
				$perpostresp["zero_four"][$value["col2"]] = $value["col1"];
				$firstfive+=$value["col1"];
			}
		}
		if(count($perpostresp["zero_four"])>=4){
		$perpostresp["fiveplus"] = $totals["posts_count"]-$firstfive;
		}
		else {
			$perpostresp["fiveplus"]=0;
		}
		
		//print_r($perpostresp);
		
		die( json_encode(
				
				array(
						'plot1' => array('internal'=>(int)$totals["internal_count"], 'external'=>(int)$totals["external_count"], 'success'=>$totals["chk"]),						
						'plot2' => array('zero'=>(int)$perpostresp["zero"], 'zero_four'=>$perpostresp["zero_four"], 'more5'=>(int)$perpostresp["fiveplus"],  'success'=>$perpostresp["chk"]),
						'plot3' => array("result"=>$domains['result'], 'success'=>$domains['chk']),
						'plot4' => array("result"=>$authavg['result'], 'success'=>$authavg['chk']),
						)				
				
				));
		
		

		/*$myFile = GUESTMOINTOR_PLUGIN_DIR."/dumpfile.txt";
		 $fh = fopen($myFile, 'w') or die("can't open file");
		
		fwrite($fh, "bgfbfg");
		fclose($fh);*/
		
		
		/*	$myFile = LINKPATROL_PLUGIN_DIR."/dumpfile.txt";
		 $fh = fopen($myFile, 'w') or die("can't open file");
		
		fwrite($fh, 'sdvsdvsd');
		fclose($fh);*/
		
		//$totaldata = $wpdb->get_results( $wpdb->prepare($sql_total),ARRAY_A );
		
	}
	
	function ajax_url_control(){
		global $wpdb;
		
	/*	$ids = array();
		$placeholders = array();
		foreach ($_POST["updatelist"] as $value) {
			$ids[] = $value["url_id"];
			$placeholders[] = "%s";
			
		}
		
		$inPart = "IN (" . implode ( ", ", $placeholders ) . ")";
		$sql = "SELECT full_url FROM {$this->linkstable} WHERE ID ".$inPart;
		
		$result= $wpdb->get_col( $wpdb->prepare($sql, $ids ));
		
		
		$result = array_unique($result);*/
		$xxx = array();
		foreach ($_POST["updatelist"] as $value) {
			$full_url = preg_replace("/[\r\n]+/", "\n", $value["url_id"]);
			$full_url = preg_replace("/\s+/", ' ', $full_url);
			$xxx[trim($full_url)] = $value["state"];
		}
		
		//$xxx = array_unique($xxx);
		
		$counter= 0;
	/*	foreach ($xxx as $key=>$value) {
			
			$result = $wpdb->update(
				$this->linkstable,
				array(
						
					'fol_strip' => $value
				),
				array( 'full_url' => $key ),
				array(
						'%d'
					 ),
					
				array( '%s' )
		);
			
			if($result)
				$counter++;
			else
				$str=$key;
		}*/
		$sql = "UPDATE {$this->linkstable} SET fol_strip=%d WHERE full_url = %s";
		
		foreach ($xxx as $key=>$value) {
			$result= $wpdb->query( $wpdb->prepare($sql, $value, $key ));
			$str = $wpdb->prepare($sql, $value, $key );
			/*if($result)
				$counter++;*/
			
		}
		
		
		
		/*$result[] = $wpdb->update(
				$this->domainstable,
				array(
						'domain' => $array[0],	// string
						'fol_strip' => $array[1]
				),
				array( 'ID' => $key ),
				array(
						'%s',
						'%d',
		
				),
				array( '%d' )
		);*/
	
		die( json_encode( array( 'success' => "Update was successful" ) ) );
	}
	
	function remove_special_chars($input){
		$input = preg_replace("/[\r\n]+/", "\n", $input);
		$input = preg_replace("/\s+/", ' ', $input);
		return trim($input);
	}
	
	
	function ajax_csv_export_handler(){
	//	if ( !current_user_can( $this->capability_reports ) )
		//	die("Don't have Permission");
	/*	var_dump($_POST['_wpnonce_linkpatrol_domains_csv']);
		echo " - ".wp_create_nonce("linkpatrol_domains_csv"); 
		var_dump(wp_verify_nonce (  $_POST['_wpnonce_linkpatrol_domains_csv'],'linkpatrol_domains_csv' ));*/
		$data= array();
		$filename = "LinkPatrolReports";
		if(isset($_POST["_wpnonce_linkpatrol_csv"])){
		if(wp_verify_nonce (  $_POST['_wpnonce_linkpatrol_csv'],'linkpatrol_csv' )){
		global$wpdb;
		
		if(isset($_POST["_wpnonce_linkpatrol_domains_csv"])){
		if(wp_verify_nonce (  $_POST['_wpnonce_linkpatrol_domains_csv'],'linkpatrol_domains_csv' )){
		$sql_tplt = "SELECT domain as col1,  SUM(link_count) as col2, COUNT(post_id) as col3, COUNT(DISTINCT author_id) as col6 
		FROM {$this->linkstable} WHERE domain NOT LIKE %s 
		GROUP BY col1 ORDER BY col2 desc";
		$tplt = $wpdb->get_results($wpdb->prepare($sql_tplt, $this->blog_domain_escaped), ARRAY_A);
		$filename = "LinkPatrol-All-Domains";
		$data[] = array("Domains","Total Links","Number of Posts", "Number of Authors");
		} 
		}
		
		if(isset($_POST["_wpnonce_linkpatrol_domain_post_report_csv"])){
		if( wp_verify_nonce( $_POST['_wpnonce_linkpatrol_domain_post_report_csv'],'linkpatrol_domain_post_report_csv' ) ) {
		$sql_tplt = "SELECT  posts.post_title, links.full_url, links.anchor_text, links.full_url, DATE_FORMAT(links.post_date,'%%m/%%d/%%Y'), users.display_name
		FROM {$this->linkstable} AS links 
		INNER JOIN {$this->poststable} AS posts 
		ON links.post_id = posts.ID 		
		INNER JOIN {$this->userstable} AS users
		ON users.ID = links.author_id 
		WHERE links.domain = %s
		ORDER BY posts.post_title asc";		
		$domain = $_POST["report_csv_domain"];
		$tplt = $wpdb->get_results($wpdb->prepare($sql_tplt, $domain), ARRAY_A);
		$filename = "Links-To-".$this->remove_special_chars($_POST["report_csv_domain"]);
		$data[] = array("Post Title","Link","Text", "Edit Date", "Author");
		}
		}
		
		if(isset($_POST["_wpnonce_linkpatrol_domain_author_post_report_csv"])){
		if(wp_verify_nonce (  $_POST['_wpnonce_linkpatrol_domain_author_post_report_csv'],'linkpatrol_domain_author_post_report_csv' )){
		$sql_tplt = "SELECT  posts.post_title, links.full_url, links.anchor_text, links.full_url, DATE_FORMAT(links.post_date,'%%m/%%d/%%Y'), users.display_name 
		FROM {$this->linkstable} AS links 
		INNER JOIN {$this->poststable} AS posts 
		ON links.post_id = posts.ID 
		INNER JOIN {$this->userstable} AS users 
		ON users.ID = links.author_id					
		WHERE domain = %s and links.author_id = %d 
		ORDER BY posts.post_title asc";		
		$authorid = $_POST["report_csv_author_id"];
		$domain = $_POST["report_csv_domain"];
		$tplt = $wpdb->get_results($wpdb->prepare($sql_tplt, $domain, $authorid, $authorid), ARRAY_A);		
		$filename = "Links-To-".$this->remove_special_chars($_POST["report_csv_domain"])."-by-".$this->remove_special_chars($_POST["report_csv_author_name"]);
		$data[] = array("Post Title","Link","Text", "Edit Date", "Author");
		}
		}
		
		if(isset($_POST["_wpnonce_linkpatrol_author_report_csv"])){
		if(wp_verify_nonce (  $_POST['_wpnonce_linkpatrol_author_report_csv'],'linkpatrol_author_report_csv' )){
		$sql_tplt = "
		SELECT users.display_name AS col1, 
		COUNT(DISTINCT links.post_id) AS col2,
		SUM(links.link_count)/COUNT(DISTINCT links.post_id) AS col3
		FROM {$this->linkstable} AS links INNER JOIN {$this->userstable} AS users
		ON links.author_id = users.ID
		WHERE links.domain not LIKE %s GROUP BY links.author_id";
		$tplt = $wpdb->get_results($wpdb->prepare($sql_tplt, $this->blog_domain_escaped ), ARRAY_A);
		$filename = "All-Authors-With-Links";
		$data[] = array("Author","Total Posts With Links","Links Per Post");
		}
		}
		
		if(isset($_POST["_wpnonce_linkpatrol_author_domain_report_csv"])){
		if(wp_verify_nonce (  $_POST['_wpnonce_linkpatrol_author_domain_report_csv'],'linkpatrol_author_domain_report_csv' )){
		$sql_tplt = 		
		"SELECT domain as col1, SUM(link_count) as col2 
		FROM {$this->linkstable} 
		where author_id = %d and domain not LIKE %s		
		GROUP BY col1 ORDER BY col2 desc";
		$authorid = $_POST["report_csv_author_id"];
		$tplt = $wpdb->get_results($wpdb->prepare($sql_tplt, $authorid, $this->blog_domain_escaped ), ARRAY_A);
		$filename = "All-Domains-".$this->remove_special_chars($_POST["report_csv_author_name"])."-is-Linking";
		$data[] = array("Domain","Total Links");
		}
		}
		
		if(isset($_POST["_wpnonce_linkpatrol_author_domain_post_report_csv"])){
		if(wp_verify_nonce (  $_POST['_wpnonce_linkpatrol_author_domain_post_report_csv'],'linkpatrol_author_domain_post_report_csv' )){
		$sql_tplt = "SELECT  posts.post_title, links.full_url, links.anchor_text, links.full_url, DATE_FORMAT(links.post_date,'%%m/%%d/%%Y'), users.display_name
		FROM {$this->linkstable} AS links
		INNER JOIN {$this->poststable} AS posts
		ON links.post_id = posts.ID
		INNER JOIN {$this->userstable} AS users
		ON users.ID = links.author_id		
		WHERE domain = %s and  links.author_id = %d
		ORDER BY posts.post_title asc";
		$authorid = $_POST["report_csv_author_id"];
		$domain = $_POST["report_csv_domain"];
		$tplt = $wpdb->get_results($wpdb->prepare($sql_tplt, $domain, $authorid, $authorid), ARRAY_A);
		$filename = "Posts-".$this->remove_special_chars($_POST["report_csv_domain"])."-added-by-".$this->remove_special_chars($_POST["report_csv_author_name"]);
		$data[] = array("Post Title","Link","Text", "Edit Date", "Author");
		}
		}
		
		if(isset($_POST["_wpnonce_linkpatrol_all_author_report_csv"])){
		if(wp_verify_nonce (  $_POST['_wpnonce_linkpatrol_all_author_report_csv'],'linkpatrol_all_author_report_csv' )){
		$sql_tplt = "
		SELECT users.display_name AS col1,		
		COUNT(DISTINCT links.post_id) AS col2, 	
		SUM(links.link_count) AS col3		
		FROM {$this->linkstable} AS links INNER JOIN {$this->userstable} AS users 
		ON links.author_id = users.ID 
		WHERE links.domain=%s
		GROUP BY links.author_id ORDER BY col2 desc";
		$domain = $_POST["report_csv_domain"];
		$tplt = $wpdb->get_results($wpdb->prepare($sql_tplt, $domain), ARRAY_A);
		$filename = "Authors-Linking-To-".$this->remove_special_chars($_POST["report_csv_domain"]);
		$data[] = array("Authors","Total Posts With Links","Number of Links");
		}
		}
		
		if(isset($_POST["_wpnonce_keyword_report_csv"])){
		if(wp_verify_nonce (  $_POST['_wpnonce_keyword_report_csv'],'linkpatrol_keyword_report_csv' )){
		$sql_tplt = "SELECT  posts.post_title, links.full_url, links.anchor_text, links.full_url, DATE_FORMAT(links.post_date,'%%m/%%d/%%Y'), users.display_name
		FROM {$this->linkstable} AS links
		INNER JOIN {$this->poststable} AS posts
		ON links.post_id = posts.ID
		INNER JOIN {$this->userstable} AS users		
		ON links.author_id = users.ID 
		WHERE domain not LIKE %s and anchor_text LIKE %s
		ORDER BY posts.post_title asc";		
		$skey = $keyword = '%' . $_POST["report_csv_skey"]. '%';
		$tplt = $wpdb->get_results($wpdb->prepare($sql_tplt, $this->blog_domain_escaped, $skey), ARRAY_A);
				
		$filename = "Keyword-".$this->remove_special_chars($_POST["report_csv_skey"]);
		$data[] = array("Post Title","Link","Text", "Edit Date", "Author");
		}
		}
		/*echo $wpdb->prepare($sql_tplt, $this->blog_domain_escaped, $skey);
		die;*/
		if (  !$tplt ) {
			$referer = add_query_arg( 'data', 'empty', wp_get_referer() );
			wp_redirect($referer );			
			exit;
		}		
		
		foreach ($tplt as $row) {
			$tmp = array();
			foreach ($row as $value) {
				$tmp[] = $value;
			}
			$data[]=$tmp;
		}		
		$csv = new CSV_Writer($data);
		$csv->headers($filename."-Reports-".date('m-d-Y', time()));
		$csv->output();
		exit;
		}
		}
	}
	

}

class CSV_Writer {

	public $data = array();
	public $deliminator;

	/**
	 * Loads data and optionally a deliminator. Data is assumed to be an array
	 * of associative arrays.
	 *
	 * @param array $data
	 * @param string $deliminator
	 */
	function __construct($data, $deliminator = ",")
	{
		if (!is_array($data))
		{
			throw new Exception('CSV_Writer only accepts data as arrays');
		}

		$this->data = $data;
		$this->deliminator = $deliminator;
	}

	private function wrap_with_quotes($data)
	{
		$data = preg_replace('/"(.+)"/', '""$1""', $data);
		return sprintf('"%s"', $data);
	}

	/**
	 * Echos the escaped CSV file with chosen delimeter
	 *
	 * @return void
	 */
	public function output()
	{
		foreach ($this->data as $row)
		{
			$quoted_data = array_map(array('CSV_Writer', 'wrap_with_quotes'), $row);
			echo sprintf("%s\n", implode($this->deliminator, $quoted_data));
		}
	}

	/**
	 * Sets proper Content-Type header and attachment for the CSV outpu
	 *
	 * @param string $name
	 * @return void
	 */
	public function headers($name)
	{
		header('Content-Type: application/csv');
		header("Content-disposition: attachment; filename={$name}.csv");
	}
}